/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;

public class DescribeListenersPublisher
implements SdkPublisher<DescribeListenersResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeListenersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeListenersPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeListenersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeListenersPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeListenersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeListenersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeListenersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Listener> listeners() {
        Function<DescribeListenersResponse, Iterator> getIterator = response -> {
            if (response != null && response.listeners() != null) {
                return response.listeners().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeListenersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeListenersPublisher resume(DescribeListenersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeListenersPublisher(this.client, (DescribeListenersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeListenersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeListenersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeListenersResponseFetcher
    implements AsyncPageFetcher<DescribeListenersResponse> {
        private DescribeListenersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeListenersResponse previousPage) {
            return previousPage.nextMarker() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextMarker()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextMarker());
        }

        public CompletableFuture<DescribeListenersResponse> nextPage(DescribeListenersResponse previousPage) {
            if (previousPage == null) {
                return DescribeListenersPublisher.this.client.describeListeners(DescribeListenersPublisher.this.firstRequest);
            }
            return DescribeListenersPublisher.this.client.describeListeners((DescribeListenersRequest)((Object)DescribeListenersPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

