/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Matcher;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTargetGroupRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, ModifyTargetGroupRequest> {
    private final String targetGroupArn;
    private final String healthCheckProtocol;
    private final String healthCheckPort;
    private final String healthCheckPath;
    private final Integer healthCheckIntervalSeconds;
    private final Integer healthCheckTimeoutSeconds;
    private final Integer healthyThresholdCount;
    private final Integer unhealthyThresholdCount;
    private final Matcher matcher;

    private ModifyTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.targetGroupArn = builder.targetGroupArn;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.healthCheckTimeoutSeconds = builder.healthCheckTimeoutSeconds;
        this.healthyThresholdCount = builder.healthyThresholdCount;
        this.unhealthyThresholdCount = builder.unhealthyThresholdCount;
        this.matcher = builder.matcher;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public ProtocolEnum healthCheckProtocol() {
        return ProtocolEnum.fromValue(this.healthCheckProtocol);
    }

    public String healthCheckProtocolAsString() {
        return this.healthCheckProtocol;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public String healthCheckPath() {
        return this.healthCheckPath;
    }

    public Integer healthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public Integer healthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds;
    }

    public Integer healthyThresholdCount() {
        return this.healthyThresholdCount;
    }

    public Integer unhealthyThresholdCount() {
        return this.unhealthyThresholdCount;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.matcher());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupRequest)) {
            return false;
        }
        ModifyTargetGroupRequest other = (ModifyTargetGroupRequest)((Object)obj);
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.healthCheckProtocolAsString(), other.healthCheckProtocolAsString()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.healthCheckPath(), other.healthCheckPath()) && Objects.equals(this.healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds()) && Objects.equals(this.healthCheckTimeoutSeconds(), other.healthCheckTimeoutSeconds()) && Objects.equals(this.healthyThresholdCount(), other.healthyThresholdCount()) && Objects.equals(this.unhealthyThresholdCount(), other.unhealthyThresholdCount()) && Objects.equals(this.matcher(), other.matcher());
    }

    public String toString() {
        return ToString.builder((String)"ModifyTargetGroupRequest").add("TargetGroupArn", (Object)this.targetGroupArn()).add("HealthCheckProtocol", (Object)this.healthCheckProtocolAsString()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("HealthCheckPath", (Object)this.healthCheckPath()).add("HealthCheckIntervalSeconds", (Object)this.healthCheckIntervalSeconds()).add("HealthCheckTimeoutSeconds", (Object)this.healthCheckTimeoutSeconds()).add("HealthyThresholdCount", (Object)this.healthyThresholdCount()).add("UnhealthyThresholdCount", (Object)this.unhealthyThresholdCount()).add("Matcher", (Object)this.matcher()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "HealthCheckProtocol": {
                return Optional.ofNullable(clazz.cast(this.healthCheckProtocolAsString()));
            }
            case "HealthCheckPort": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPort()));
            }
            case "HealthCheckPath": {
                return Optional.ofNullable(clazz.cast(this.healthCheckPath()));
            }
            case "HealthCheckIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckIntervalSeconds()));
            }
            case "HealthCheckTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckTimeoutSeconds()));
            }
            case "HealthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.healthyThresholdCount()));
            }
            case "UnhealthyThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThresholdCount()));
            }
            case "Matcher": {
                return Optional.ofNullable(clazz.cast(this.matcher()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private String healthCheckProtocol;
        private String healthCheckPort;
        private String healthCheckPath;
        private Integer healthCheckIntervalSeconds;
        private Integer healthCheckTimeoutSeconds;
        private Integer healthyThresholdCount;
        private Integer unhealthyThresholdCount;
        private Matcher matcher;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupRequest model) {
            super(model);
            this.targetGroupArn(model.targetGroupArn);
            this.healthCheckProtocol(model.healthCheckProtocol);
            this.healthCheckPort(model.healthCheckPort);
            this.healthCheckPath(model.healthCheckPath);
            this.healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            this.healthCheckTimeoutSeconds(model.healthCheckTimeoutSeconds);
            this.healthyThresholdCount(model.healthyThresholdCount);
            this.unhealthyThresholdCount(model.unhealthyThresholdCount);
            this.matcher(model.matcher);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final String getHealthCheckProtocol() {
            return this.healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(ProtocolEnum healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return this.healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getHealthCheckTimeoutSeconds() {
            return this.healthCheckTimeoutSeconds;
        }

        @Override
        public final Builder healthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
            return this;
        }

        public final void setHealthCheckTimeoutSeconds(Integer healthCheckTimeoutSeconds) {
            this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
        }

        public final Integer getHealthyThresholdCount() {
            return this.healthyThresholdCount;
        }

        @Override
        public final Builder healthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
            return this;
        }

        public final void setHealthyThresholdCount(Integer healthyThresholdCount) {
            this.healthyThresholdCount = healthyThresholdCount;
        }

        public final Integer getUnhealthyThresholdCount() {
            return this.unhealthyThresholdCount;
        }

        @Override
        public final Builder unhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
            return this;
        }

        public final void setUnhealthyThresholdCount(Integer unhealthyThresholdCount) {
            this.unhealthyThresholdCount = unhealthyThresholdCount;
        }

        public final Matcher.Builder getMatcher() {
            return this.matcher != null ? this.matcher.toBuilder() : null;
        }

        @Override
        public final Builder matcher(Matcher matcher) {
            this.matcher = matcher;
            return this;
        }

        public final void setMatcher(Matcher.BuilderImpl matcher) {
            this.matcher = matcher != null ? matcher.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTargetGroupRequest build() {
            return new ModifyTargetGroupRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    CopyableBuilder<Builder, ModifyTargetGroupRequest> {
        public Builder targetGroupArn(String var1);

        public Builder healthCheckProtocol(String var1);

        public Builder healthCheckProtocol(ProtocolEnum var1);

        public Builder healthCheckPort(String var1);

        public Builder healthCheckPath(String var1);

        public Builder healthCheckIntervalSeconds(Integer var1);

        public Builder healthCheckTimeoutSeconds(Integer var1);

        public Builder healthyThresholdCount(Integer var1);

        public Builder unhealthyThresholdCount(Integer var1);

        public Builder matcher(Matcher var1);

        default public Builder matcher(Consumer<Matcher.Builder> matcher) {
            return this.matcher((Matcher)((Matcher.Builder)Matcher.builder().applyMutation(matcher)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

