/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements ToCopyableBuilder<Builder, Action> {
    private final String type;
    private final String targetGroupArn;

    private Action(BuilderImpl builder) {
        this.type = builder.type;
        this.targetGroupArn = builder.targetGroupArn;
    }

    public ActionTypeEnum type() {
        return ActionTypeEnum.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.targetGroupArn(), other.targetGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"Action").add("Type", (Object)this.typeAsString()).add("TargetGroupArn", (Object)this.targetGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TargetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String targetGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.type(model.type);
            this.targetGroupArn(model.targetGroupArn);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public Action build() {
            return new Action(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Action> {
        public Builder type(String var1);

        public Builder type(ActionTypeEnum var1);

        public Builder targetGroupArn(String var1);
    }
}

