/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;

public class TargetDescriptionUnmarshaller
implements Unmarshaller<TargetDescription, StaxUnmarshallerContext> {
    private static final TargetDescriptionUnmarshaller INSTANCE = new TargetDescriptionUnmarshaller();

    public TargetDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TargetDescription.Builder targetDescription = TargetDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    targetDescription.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    targetDescription.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AvailabilityZone", targetDepth)) continue;
                targetDescription.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TargetDescription)targetDescription.build();
    }

    public static TargetDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

