/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;

public class DescribeRulesRequestMarshaller
implements Marshaller<Request<DescribeRulesRequest>, DescribeRulesRequest> {
    public Request<DescribeRulesRequest> marshall(DescribeRulesRequest describeRulesRequest) {
        List<String> ruleArnsList;
        if (describeRulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeRulesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeRules");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeRulesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)describeRulesRequest.listenerArn()));
        }
        if ((ruleArnsList = describeRulesRequest.ruleArns()) != null) {
            if (!ruleArnsList.isEmpty()) {
                int ruleArnsListIndex = 1;
                for (String ruleArnsListValue : ruleArnsList) {
                    if (ruleArnsListValue != null) {
                        request.addParameter("RuleArns.member." + ruleArnsListIndex, StringUtils.fromString((String)ruleArnsListValue));
                    }
                    ++ruleArnsListIndex;
                }
            } else {
                request.addParameter("RuleArns", "");
            }
        }
        if (describeRulesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeRulesRequest.marker()));
        }
        if (describeRulesRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeRulesRequest.pageSize()));
        }
        return request;
    }
}

