/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingv2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;

public class DescribeTargetGroupsPublisher
implements SdkPublisher<DescribeTargetGroupsResponse> {
    private final ElasticLoadBalancingv2AsyncClient client;
    private final DescribeTargetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTargetGroupsPublisher(ElasticLoadBalancingv2AsyncClient client, DescribeTargetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTargetGroupsPublisher(ElasticLoadBalancingv2AsyncClient client, DescribeTargetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTargetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTargetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<TargetGroup> targetGroups() {
        Function<DescribeTargetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targetGroups() != null) {
                return response.targetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeTargetGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeTargetGroupsPublisher resume(DescribeTargetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeTargetGroupsPublisher(this.client, (DescribeTargetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextMarker()).build()));
        }
        return new DescribeTargetGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeTargetGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeTargetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeTargetGroupsResponse> {
        private DescribeTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTargetGroupsResponse previousPage) {
            return previousPage.nextMarker() != null;
        }

        public CompletableFuture<DescribeTargetGroupsResponse> nextPage(DescribeTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTargetGroupsPublisher.this.client.describeTargetGroups(DescribeTargetGroupsPublisher.this.firstRequest);
            }
            return DescribeTargetGroupsPublisher.this.client.describeTargetGroups((DescribeTargetGroupsRequest)((Object)DescribeTargetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

