/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetHealthDescription
implements ToCopyableBuilder<Builder, TargetHealthDescription> {
    private final TargetDescription target;
    private final String healthCheckPort;
    private final TargetHealth targetHealth;

    private TargetHealthDescription(BuilderImpl builder) {
        this.target = builder.target;
        this.healthCheckPort = builder.healthCheckPort;
        this.targetHealth = builder.targetHealth;
    }

    public TargetDescription target() {
        return this.target;
    }

    public String healthCheckPort() {
        return this.healthCheckPort;
    }

    public TargetHealth targetHealth() {
        return this.targetHealth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetHealth());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealthDescription)) {
            return false;
        }
        TargetHealthDescription other = (TargetHealthDescription)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.healthCheckPort(), other.healthCheckPort()) && Objects.equals(this.targetHealth(), other.targetHealth());
    }

    public String toString() {
        return ToString.builder((String)"TargetHealthDescription").add("Target", (Object)this.target()).add("HealthCheckPort", (Object)this.healthCheckPort()).add("TargetHealth", (Object)this.targetHealth()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.of(clazz.cast(this.target()));
            }
            case "HealthCheckPort": {
                return Optional.of(clazz.cast(this.healthCheckPort()));
            }
            case "TargetHealth": {
                return Optional.of(clazz.cast(this.targetHealth()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private TargetDescription target;
        private String healthCheckPort;
        private TargetHealth targetHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealthDescription model) {
            this.target(model.target);
            this.healthCheckPort(model.healthCheckPort);
            this.targetHealth(model.targetHealth);
        }

        public final TargetDescription.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(TargetDescription target) {
            this.target = target;
            return this;
        }

        public final void setTarget(TargetDescription.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final String getHealthCheckPort() {
            return this.healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final TargetHealth.Builder getTargetHealth() {
            return this.targetHealth != null ? this.targetHealth.toBuilder() : null;
        }

        @Override
        public final Builder targetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
            return this;
        }

        public final void setTargetHealth(TargetHealth.BuilderImpl targetHealth) {
            this.targetHealth = targetHealth != null ? targetHealth.build() : null;
        }

        public TargetHealthDescription build() {
            return new TargetHealthDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetHealthDescription> {
        public Builder target(TargetDescription var1);

        default public Builder target(Consumer<TargetDescription.Builder> target) {
            return this.target((TargetDescription)((TargetDescription.Builder)TargetDescription.builder().apply(target)).build());
        }

        public Builder healthCheckPort(String var1);

        public Builder targetHealth(TargetHealth var1);

        default public Builder targetHealth(Consumer<TargetHealth.Builder> targetHealth) {
            return this.targetHealth((TargetHealth)((TargetHealth.Builder)TargetHealth.builder().apply(targetHealth)).build());
        }
    }
}

