/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyTargetGroupAttributesRequest
extends ElasticLoadBalancingv2Request
implements ToCopyableBuilder<Builder, ModifyTargetGroupAttributesRequest> {
    private final String targetGroupArn;
    private final List<TargetGroupAttribute> attributes;

    private ModifyTargetGroupAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.targetGroupArn = builder.targetGroupArn;
        this.attributes = builder.attributes;
    }

    public String targetGroupArn() {
        return this.targetGroupArn;
    }

    public List<TargetGroupAttribute> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTargetGroupAttributesRequest)) {
            return false;
        }
        ModifyTargetGroupAttributesRequest other = (ModifyTargetGroupAttributesRequest)((Object)obj);
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"ModifyTargetGroupAttributesRequest").add("TargetGroupArn", (Object)this.targetGroupArn()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupArn": {
                return Optional.of(clazz.cast(this.targetGroupArn()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Request.BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private List<TargetGroupAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTargetGroupAttributesRequest model) {
            super(model);
            this.targetGroupArn(model.targetGroupArn);
            this.attributes(model.attributes);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        public final Collection<TargetGroupAttribute.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(TargetGroupAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<TargetGroupAttribute> attributes) {
            this.attributes = TargetGroupAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(TargetGroupAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<TargetGroupAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (TargetGroupAttribute)((TargetGroupAttribute.Builder)TargetGroupAttribute.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<TargetGroupAttribute.BuilderImpl> attributes) {
            this.attributes = TargetGroupAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyTargetGroupAttributesRequest build() {
            return new ModifyTargetGroupAttributesRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Request.Builder,
    CopyableBuilder<Builder, ModifyTargetGroupAttributesRequest> {
        public Builder targetGroupArn(String var1);

        public Builder attributes(Collection<TargetGroupAttribute> var1);

        public Builder attributes(TargetGroupAttribute ... var1);

        public Builder attributes(Consumer<TargetGroupAttribute.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

