/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyRuleResponse
extends ElasticLoadBalancingv2Response
implements ToCopyableBuilder<Builder, ModifyRuleResponse> {
    private final List<Rule> rules;

    private ModifyRuleResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRuleResponse)) {
            return false;
        }
        ModifyRuleResponse other = (ModifyRuleResponse)((Object)obj);
        return Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"ModifyRuleResponse").add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Response.BuilderImpl
    implements Builder {
        private List<Rule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRuleResponse model) {
            super(model);
            this.rules(model.rules);
        }

        public final Collection<Rule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public ModifyRuleResponse build() {
            return new ModifyRuleResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Response.Builder,
    CopyableBuilder<Builder, ModifyRuleResponse> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);
    }
}

