/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleConditionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRuleRequest
extends ElasticLoadBalancingv2Request
implements ToCopyableBuilder<Builder, CreateRuleRequest> {
    private final String listenerArn;
    private final List<RuleCondition> conditions;
    private final Integer priority;
    private final List<Action> actions;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.conditions = builder.conditions;
        this.priority = builder.priority;
        this.actions = builder.actions;
    }

    public String listenerArn() {
        return this.listenerArn;
    }

    public List<RuleCondition> conditions() {
        return this.conditions;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<Action> actions() {
        return this.actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)((Object)obj);
        return Objects.equals(this.listenerArn(), other.listenerArn()) && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.actions(), other.actions());
    }

    public String toString() {
        return ToString.builder((String)"CreateRuleRequest").add("ListenerArn", (Object)this.listenerArn()).add("Conditions", this.conditions()).add("Priority", (Object)this.priority()).add("Actions", this.actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ListenerArn": {
                return Optional.of(clazz.cast(this.listenerArn()));
            }
            case "Conditions": {
                return Optional.of(clazz.cast(this.conditions()));
            }
            case "Priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "Actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Request.BuilderImpl
    implements Builder {
        private String listenerArn;
        private List<RuleCondition> conditions;
        private Integer priority;
        private List<Action> actions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            this.listenerArn(model.listenerArn);
            this.conditions(model.conditions);
            this.priority(model.priority);
            this.actions(model.actions);
        }

        public final String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<RuleCondition.Builder> getConditions() {
            return this.conditions != null ? (Collection)this.conditions.stream().map(RuleCondition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<RuleCondition> conditions) {
            this.conditions = RuleConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(RuleCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<RuleCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (RuleCondition)((RuleCondition.Builder)RuleCondition.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConditions(Collection<RuleCondition.BuilderImpl> conditions) {
            this.conditions = RuleConditionListCopier.copyFromBuilder(conditions);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<Action.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Request.Builder,
    CopyableBuilder<Builder, CreateRuleRequest> {
        public Builder listenerArn(String var1);

        public Builder conditions(Collection<RuleCondition> var1);

        public Builder conditions(RuleCondition ... var1);

        public Builder conditions(Consumer<RuleCondition.Builder> ... var1);

        public Builder priority(Integer var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

