/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerResponse
extends ElasticLoadBalancingv2Response
implements ToCopyableBuilder<Builder, CreateLoadBalancerResponse> {
    private final List<LoadBalancer> loadBalancers;

    private CreateLoadBalancerResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancers = builder.loadBalancers;
    }

    public List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerResponse)) {
            return false;
        }
        CreateLoadBalancerResponse other = (CreateLoadBalancerResponse)((Object)obj);
        return Objects.equals(this.loadBalancers(), other.loadBalancers());
    }

    public String toString() {
        return ToString.builder((String)"CreateLoadBalancerResponse").add("LoadBalancers", this.loadBalancers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancers": {
                return Optional.of(clazz.cast(this.loadBalancers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Response.BuilderImpl
    implements Builder {
        private List<LoadBalancer> loadBalancers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerResponse model) {
            super(model);
            this.loadBalancers(model.loadBalancers);
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return this.loadBalancers != null ? (Collection)this.loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public CreateLoadBalancerResponse build() {
            return new CreateLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Response.Builder,
    CopyableBuilder<Builder, CreateLoadBalancerResponse> {
        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);
    }
}

