/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingv2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMappingsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoadBalancerRequest
extends ElasticLoadBalancingv2Request
implements ToCopyableBuilder<Builder, CreateLoadBalancerRequest> {
    private final String name;
    private final List<String> subnets;
    private final List<SubnetMapping> subnetMappings;
    private final List<String> securityGroups;
    private final String scheme;
    private final List<Tag> tags;
    private final String type;
    private final String ipAddressType;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.subnets = builder.subnets;
        this.subnetMappings = builder.subnetMappings;
        this.securityGroups = builder.securityGroups;
        this.scheme = builder.scheme;
        this.tags = builder.tags;
        this.type = builder.type;
        this.ipAddressType = builder.ipAddressType;
    }

    public String name() {
        return this.name;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public LoadBalancerSchemeEnum scheme() {
        return LoadBalancerSchemeEnum.fromValue(this.scheme);
    }

    public String schemeAsString() {
        return this.scheme;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public LoadBalancerTypeEnum type() {
        return LoadBalancerTypeEnum.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.subnetMappings(), other.subnetMappings()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.schemeAsString(), other.schemeAsString()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateLoadBalancerRequest").add("Name", (Object)this.name()).add("Subnets", this.subnets()).add("SubnetMappings", this.subnetMappings()).add("SecurityGroups", this.securityGroups()).add("Scheme", (Object)this.schemeAsString()).add("Tags", this.tags()).add("Type", (Object)this.typeAsString()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Subnets": {
                return Optional.of(clazz.cast(this.subnets()));
            }
            case "SubnetMappings": {
                return Optional.of(clazz.cast(this.subnetMappings()));
            }
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "Scheme": {
                return Optional.of(clazz.cast(this.schemeAsString()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "IpAddressType": {
                return Optional.of(clazz.cast(this.ipAddressTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingv2Request.BuilderImpl
    implements Builder {
        private String name;
        private List<String> subnets;
        private List<SubnetMapping> subnetMappings;
        private List<String> securityGroups;
        private String scheme;
        private List<Tag> tags;
        private String type;
        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            super(model);
            this.name(model.name);
            this.subnets(model.subnets);
            this.subnetMappings(model.subnetMappings);
            this.securityGroups(model.securityGroups);
            this.scheme(model.scheme);
            this.tags(model.tags);
            this.type(model.type);
            this.ipAddressType(model.ipAddressType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        public final Collection<SubnetMapping.Builder> getSubnetMappings() {
            return this.subnetMappings != null ? (Collection)this.subnetMappings.stream().map(SubnetMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder> ... subnetMappings) {
            this.subnetMappings(Stream.of(subnetMappings).map(c -> (SubnetMapping)((SubnetMapping.Builder)SubnetMapping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        public final String getScheme() {
            return this.scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme.toString());
            return this;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoadBalancerTypeEnum type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingv2Request.Builder,
    CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        public Builder name(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);

        public Builder subnetMappings(Consumer<SubnetMapping.Builder> ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder scheme(String var1);

        public Builder scheme(LoadBalancerSchemeEnum var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(LoadBalancerTypeEnum var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

