/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;

public class TargetHealthUnmarshaller
implements Unmarshaller<TargetHealth, StaxUnmarshallerContext> {
    private static TargetHealthUnmarshaller INSTANCE;

    public TargetHealth unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TargetHealth.Builder targetHealth = TargetHealth.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("State", targetDepth)) {
                    targetHealth.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Reason", targetDepth)) {
                    targetHealth.reason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                targetHealth.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TargetHealth)targetHealth.build();
    }

    public static TargetHealthUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TargetHealthUnmarshaller();
        }
        return INSTANCE;
    }
}

