/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ActionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CertificateUnmarshaller;

public class ListenerUnmarshaller
implements Unmarshaller<Listener, StaxUnmarshallerContext> {
    private static ListenerUnmarshaller INSTANCE;

    public Listener unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Listener.Builder listener = Listener.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ListenerArn", targetDepth)) {
                    listener.listenerArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadBalancerArn", targetDepth)) {
                    listener.loadBalancerArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    listener.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Protocol", targetDepth)) {
                    listener.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Certificates", targetDepth)) {
                    listener.certificates(new ArrayList<Certificate>());
                    continue;
                }
                if (context.testExpression("Certificates/member", targetDepth)) {
                    listener.certificates(CertificateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SslPolicy", targetDepth)) {
                    listener.sslPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultActions", targetDepth)) {
                    listener.defaultActions(new ArrayList<Action>());
                    continue;
                }
                if (!context.testExpression("DefaultActions/member", targetDepth)) continue;
                listener.defaultActions(ActionUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Listener)listener.build();
    }

    public static ListenerUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ListenerUnmarshaller();
        }
        return INSTANCE;
    }
}

