/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import software.amazon.awssdk.util.StringUtils;

public class DescribeTargetHealthRequestMarshaller
implements Marshaller<Request<DescribeTargetHealthRequest>, DescribeTargetHealthRequest> {
    public Request<DescribeTargetHealthRequest> marshall(DescribeTargetHealthRequest describeTargetHealthRequest) {
        List<TargetDescription> targetsList;
        if (describeTargetHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTargetHealthRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeTargetHealth");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTargetHealthRequest.targetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString((String)describeTargetHealthRequest.targetGroupArn()));
        }
        if ((targetsList = describeTargetHealthRequest.targets()) != null) {
            if (targetsList.isEmpty()) {
                request.addParameter("Targets", "");
            } else {
                int targetsListIndex = 1;
                for (TargetDescription targetsListValue : targetsList) {
                    if (targetsListValue.id() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Id", StringUtils.fromString((String)targetsListValue.id()));
                    }
                    if (targetsListValue.port() != null) {
                        request.addParameter("Targets.member." + targetsListIndex + ".Port", StringUtils.fromInteger((Integer)targetsListValue.port()));
                    }
                    ++targetsListIndex;
                }
            }
        }
        return request;
    }
}

