/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPoliciesCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSSLPoliciesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSSLPoliciesResponse> {
    private final List<SslPolicy> sslPolicies;
    private final String nextMarker;

    private DescribeSSLPoliciesResponse(BuilderImpl builder) {
        this.sslPolicies = builder.sslPolicies;
        this.nextMarker = builder.nextMarker;
    }

    public List<SslPolicy> sslPolicies() {
        return this.sslPolicies;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sslPolicies() == null ? 0 : this.sslPolicies().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSSLPoliciesResponse)) {
            return false;
        }
        DescribeSSLPoliciesResponse other = (DescribeSSLPoliciesResponse)((Object)obj);
        if (other.sslPolicies() == null ^ this.sslPolicies() == null) {
            return false;
        }
        if (other.sslPolicies() != null && !other.sslPolicies().equals(this.sslPolicies())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sslPolicies() != null) {
            sb.append("SslPolicies: ").append(this.sslPolicies()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<SslPolicy> sslPolicies;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSSLPoliciesResponse model) {
            this.setSslPolicies(model.sslPolicies);
            this.setNextMarker(model.nextMarker);
        }

        public final Collection<SslPolicy> getSslPolicies() {
            return this.sslPolicies;
        }

        @Override
        public final Builder sslPolicies(Collection<SslPolicy> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copy(sslPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sslPolicies(SslPolicy ... sslPolicies) {
            if (this.sslPolicies == null) {
                this.sslPolicies = new ArrayList<SslPolicy>(sslPolicies.length);
            }
            for (SslPolicy e : sslPolicies) {
                this.sslPolicies.add(e);
            }
            return this;
        }

        public final void setSslPolicies(Collection<SslPolicy> sslPolicies) {
            this.sslPolicies = SslPoliciesCopier.copy(sslPolicies);
        }

        @SafeVarargs
        public final void setSslPolicies(SslPolicy ... sslPolicies) {
            if (this.sslPolicies == null) {
                this.sslPolicies = new ArrayList<SslPolicy>(sslPolicies.length);
            }
            for (SslPolicy e : sslPolicies) {
                this.sslPolicies.add(e);
            }
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeSSLPoliciesResponse build() {
            return new DescribeSSLPoliciesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSSLPoliciesResponse> {
        public Builder sslPolicies(Collection<SslPolicy> var1);

        public Builder sslPolicies(SslPolicy ... var1);

        public Builder nextMarker(String var1);
    }
}

