/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleArnsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRulesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRulesRequest> {
    private final String listenerArn;
    private final List<String> ruleArns;
    private final String marker;
    private final Integer pageSize;

    private DescribeRulesRequest(BuilderImpl builder) {
        this.listenerArn = builder.listenerArn;
        this.ruleArns = builder.ruleArns;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public String listenerArn() {
        return this.listenerArn;
    }

    public List<String> ruleArns() {
        return this.ruleArns;
    }

    public String marker() {
        return this.marker;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.listenerArn() == null ? 0 : this.listenerArn().hashCode());
        hashCode = 31 * hashCode + (this.ruleArns() == null ? 0 : this.ruleArns().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesRequest)) {
            return false;
        }
        DescribeRulesRequest other = (DescribeRulesRequest)((Object)obj);
        if (other.listenerArn() == null ^ this.listenerArn() == null) {
            return false;
        }
        if (other.listenerArn() != null && !other.listenerArn().equals(this.listenerArn())) {
            return false;
        }
        if (other.ruleArns() == null ^ this.ruleArns() == null) {
            return false;
        }
        if (other.ruleArns() != null && !other.ruleArns().equals(this.ruleArns())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        return other.pageSize() == null || other.pageSize().equals(this.pageSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.listenerArn() != null) {
            sb.append("ListenerArn: ").append(this.listenerArn()).append(",");
        }
        if (this.ruleArns() != null) {
            sb.append("RuleArns: ").append(this.ruleArns()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String listenerArn;
        private List<String> ruleArns;
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesRequest model) {
            this.setListenerArn(model.listenerArn);
            this.setRuleArns(model.ruleArns);
            this.setMarker(model.marker);
            this.setPageSize(model.pageSize);
        }

        public final String getListenerArn() {
            return this.listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<String> getRuleArns() {
            return this.ruleArns;
        }

        @Override
        public final Builder ruleArns(Collection<String> ruleArns) {
            this.ruleArns = RuleArnsCopier.copy(ruleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleArns(String ... ruleArns) {
            if (this.ruleArns == null) {
                this.ruleArns = new ArrayList<String>(ruleArns.length);
            }
            for (String e : ruleArns) {
                this.ruleArns.add(e);
            }
            return this;
        }

        public final void setRuleArns(Collection<String> ruleArns) {
            this.ruleArns = RuleArnsCopier.copy(ruleArns);
        }

        @SafeVarargs
        public final void setRuleArns(String ... ruleArns) {
            if (this.ruleArns == null) {
                this.ruleArns = new ArrayList<String>(ruleArns.length);
            }
            for (String e : ruleArns) {
                this.ruleArns.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public DescribeRulesRequest build() {
            return new DescribeRulesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRulesRequest> {
        public Builder listenerArn(String var1);

        public Builder ruleArns(Collection<String> var1);

        public Builder ruleArns(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);
    }
}

