/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagDescription;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.TagUnmarshaller;

public class TagDescriptionUnmarshaller
implements Unmarshaller<TagDescription, StaxUnmarshallerContext> {
    private static TagDescriptionUnmarshaller INSTANCE;

    public TagDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TagDescription.Builder tagDescription = TagDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceArn", targetDepth)) {
                    tagDescription.resourceArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    tagDescription.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/member", targetDepth)) continue;
                tagDescription.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TagDescription)tagDescription.build();
    }

    public static TagDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

