/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetRulePrioritiesRequestMarshaller
implements Marshaller<Request<SetRulePrioritiesRequest>, SetRulePrioritiesRequest> {
    public Request<SetRulePrioritiesRequest> marshall(SetRulePrioritiesRequest setRulePrioritiesRequest) {
        if (setRulePrioritiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setRulePrioritiesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "SetRulePriorities");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<RulePriorityPair> rulePrioritiesList = setRulePrioritiesRequest.rulePriorities();
        if (rulePrioritiesList != null) {
            if (rulePrioritiesList.isEmpty()) {
                request.addParameter("RulePriorities", "");
            } else {
                int rulePrioritiesListIndex = 1;
                for (RulePriorityPair rulePrioritiesListValue : rulePrioritiesList) {
                    if (rulePrioritiesListValue.ruleArn() != null) {
                        request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".RuleArn", StringUtils.fromString((String)rulePrioritiesListValue.ruleArn()));
                    }
                    if (rulePrioritiesListValue.priority() != null) {
                        request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".Priority", StringUtils.fromInteger((Integer)rulePrioritiesListValue.priority()));
                    }
                    ++rulePrioritiesListIndex;
                }
            }
        }
        return request;
    }
}

