/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ActionUnmarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RuleConditionUnmarshaller;

public class RuleUnmarshaller
implements Unmarshaller<Rule, StaxUnmarshallerContext> {
    private static RuleUnmarshaller INSTANCE;

    public Rule unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Rule.Builder rule = Rule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("RuleArn", targetDepth)) {
                    rule.ruleArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Priority", targetDepth)) {
                    rule.priority(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Conditions", targetDepth)) {
                    rule.conditions(new ArrayList<RuleCondition>());
                    continue;
                }
                if (context.testExpression("Conditions/member", targetDepth)) {
                    rule.conditions(RuleConditionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Actions", targetDepth)) {
                    rule.actions(new ArrayList<Action>());
                    continue;
                }
                if (context.testExpression("Actions/member", targetDepth)) {
                    rule.actions(ActionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsDefault", targetDepth)) continue;
                rule.isDefault(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Rule)rule.build();
    }

    public static RuleUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RuleUnmarshaller();
        }
        return INSTANCE;
    }
}

