/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeRulesRequestMarshaller
implements Marshaller<Request<DescribeRulesRequest>, DescribeRulesRequest> {
    public Request<DescribeRulesRequest> marshall(DescribeRulesRequest describeRulesRequest) {
        List<String> ruleArnsList;
        if (describeRulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRulesRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "DescribeRules");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeRulesRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)describeRulesRequest.listenerArn()));
        }
        if ((ruleArnsList = describeRulesRequest.ruleArns()) != null) {
            if (ruleArnsList.isEmpty()) {
                request.addParameter("RuleArns", "");
            } else {
                int ruleArnsListIndex = 1;
                for (String ruleArnsListValue : ruleArnsList) {
                    if (ruleArnsListValue != null) {
                        request.addParameter("RuleArns.member." + ruleArnsListIndex, StringUtils.fromString((String)ruleArnsListValue));
                    }
                    ++ruleArnsListIndex;
                }
            }
        }
        if (describeRulesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeRulesRequest.marker()));
        }
        if (describeRulesRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeRulesRequest.pageSize()));
        }
        return request;
    }
}

