/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.util.StringUtils;

public class CreateRuleRequestMarshaller
implements Marshaller<Request<CreateRuleRequest>, CreateRuleRequest> {
    public Request<CreateRuleRequest> marshall(CreateRuleRequest createRuleRequest) {
        List<Action> actionsList;
        List<RuleCondition> conditionsList;
        if (createRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRuleRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "CreateRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRuleRequest.listenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)createRuleRequest.listenerArn()));
        }
        if ((conditionsList = createRuleRequest.conditions()) != null) {
            if (conditionsList.isEmpty()) {
                request.addParameter("Conditions", "");
            } else {
                int conditionsListIndex = 1;
                for (RuleCondition conditionsListValue : conditionsList) {
                    List<String> valuesList;
                    if (conditionsListValue.field() != null) {
                        request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringUtils.fromString((String)conditionsListValue.field()));
                    }
                    if ((valuesList = conditionsListValue.values()) != null) {
                        if (valuesList.isEmpty()) {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                        } else {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        }
                    }
                    ++conditionsListIndex;
                }
            }
        }
        if (createRuleRequest.priority() != null) {
            request.addParameter("Priority", StringUtils.fromInteger((Integer)createRuleRequest.priority()));
        }
        if ((actionsList = createRuleRequest.actions()) != null) {
            if (actionsList.isEmpty()) {
                request.addParameter("Actions", "");
            } else {
                int actionsListIndex = 1;
                for (Action actionsListValue : actionsList) {
                    if (actionsListValue.type() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".Type", StringUtils.fromString((String)actionsListValue.type()));
                    }
                    if (actionsListValue.targetGroupArn() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)actionsListValue.targetGroupArn()));
                    }
                    ++actionsListIndex;
                }
            }
        }
        return request;
    }
}

