/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateLoadBalancerRequestMarshaller
implements Marshaller<Request<CreateLoadBalancerRequest>, CreateLoadBalancerRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateLoadBalancerRequest> marshall(CreateLoadBalancerRequest createLoadBalancerRequest) {
        List<Tag> tagsList;
        List<String> securityGroupsList;
        List<String> subnetsList;
        if (createLoadBalancerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLoadBalancerRequest, "ElasticLoadBalancingv2Client");
        request.addParameter("Action", "CreateLoadBalancer");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoadBalancerRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createLoadBalancerRequest.name()));
        }
        if ((subnetsList = createLoadBalancerRequest.subnets()) != null) {
            if (subnetsList.isEmpty()) {
                request.addParameter("Subnets", "");
            } else {
                int subnetsListIndex = 1;
                for (String string : subnetsList) {
                    if (string != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)string));
                    }
                    ++subnetsListIndex;
                }
            }
        }
        if ((securityGroupsList = createLoadBalancerRequest.securityGroups()) != null) {
            if (securityGroupsList.isEmpty()) {
                request.addParameter("SecurityGroups", "");
            } else {
                int securityGroupsListIndex = 1;
                for (String securityGroupsListValue : securityGroupsList) {
                    if (securityGroupsListValue != null) {
                        request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        if (createLoadBalancerRequest.scheme() != null) {
            request.addParameter("Scheme", StringUtils.fromString((String)createLoadBalancerRequest.scheme()));
        }
        if ((tagsList = createLoadBalancerRequest.tags()) != null) {
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            }
        }
        if (createLoadBalancerRequest.ipAddressType() != null) {
            request.addParameter("IpAddressType", StringUtils.fromString((String)createLoadBalancerRequest.ipAddressType()));
        }
        return request;
    }
}

