/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetRulePrioritiesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetRulePrioritiesRequest> {
    private final List<RulePriorityPair> rulePriorities;

    private SetRulePrioritiesRequest(BuilderImpl builder) {
        this.rulePriorities = builder.rulePriorities;
    }

    public List<RulePriorityPair> rulePriorities() {
        return this.rulePriorities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rulePriorities() == null ? 0 : this.rulePriorities().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRulePrioritiesRequest)) {
            return false;
        }
        SetRulePrioritiesRequest other = (SetRulePrioritiesRequest)((Object)obj);
        if (other.rulePriorities() == null ^ this.rulePriorities() == null) {
            return false;
        }
        return other.rulePriorities() == null || other.rulePriorities().equals(this.rulePriorities());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rulePriorities() != null) {
            sb.append("RulePriorities: ").append(this.rulePriorities()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<RulePriorityPair> rulePriorities;

        private BuilderImpl() {
        }

        private BuilderImpl(SetRulePrioritiesRequest model) {
            this.setRulePriorities(model.rulePriorities);
        }

        public final Collection<RulePriorityPair> getRulePriorities() {
            return this.rulePriorities;
        }

        @Override
        public final Builder rulePriorities(Collection<RulePriorityPair> rulePriorities) {
            this.rulePriorities = RulePriorityListCopier.copy(rulePriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulePriorities(RulePriorityPair ... rulePriorities) {
            if (this.rulePriorities == null) {
                this.rulePriorities = new ArrayList<RulePriorityPair>(rulePriorities.length);
            }
            for (RulePriorityPair e : rulePriorities) {
                this.rulePriorities.add(e);
            }
            return this;
        }

        public final void setRulePriorities(Collection<RulePriorityPair> rulePriorities) {
            this.rulePriorities = RulePriorityListCopier.copy(rulePriorities);
        }

        @SafeVarargs
        public final void setRulePriorities(RulePriorityPair ... rulePriorities) {
            if (this.rulePriorities == null) {
                this.rulePriorities = new ArrayList<RulePriorityPair>(rulePriorities.length);
            }
            for (RulePriorityPair e : rulePriorities) {
                this.rulePriorities.add(e);
            }
        }

        public SetRulePrioritiesRequest build() {
            return new SetRulePrioritiesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetRulePrioritiesRequest> {
        public Builder rulePriorities(Collection<RulePriorityPair> var1);

        public Builder rulePriorities(RulePriorityPair ... var1);
    }
}

