/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListOfStringCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RuleCondition
implements ToCopyableBuilder<Builder, RuleCondition> {
    private final String field;
    private final List<String> values;

    private RuleCondition(BuilderImpl builder) {
        this.field = builder.field;
        this.values = builder.values;
    }

    public String field() {
        return this.field;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.field() == null ? 0 : this.field().hashCode());
        hashCode = 31 * hashCode + (this.values() == null ? 0 : this.values().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition)obj;
        if (other.field() == null ^ this.field() == null) {
            return false;
        }
        if (other.field() != null && !other.field().equals(this.field())) {
            return false;
        }
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        return other.values() == null || other.values().equals(this.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.field() != null) {
            sb.append("Field: ").append(this.field()).append(",");
        }
        if (this.values() != null) {
            sb.append("Values: ").append(this.values()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String field;
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleCondition model) {
            this.setField(model.field);
            this.setValues(model.values);
        }

        public final String getField() {
            return this.field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            if (this.values == null) {
                this.values = new ArrayList<String>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
        }

        @SafeVarargs
        public final void setValues(String ... values) {
            if (this.values == null) {
                this.values = new ArrayList<String>(values.length);
            }
            for (String e : values) {
                this.values.add(e);
            }
        }

        public RuleCondition build() {
            return new RuleCondition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RuleCondition> {
        public Builder field(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

