/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRulesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeRulesResponse> {
    private final List<Rule> rules;
    private final String nextMarker;

    private DescribeRulesResponse(BuilderImpl builder) {
        this.rules = builder.rules;
        this.nextMarker = builder.nextMarker;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRulesResponse)) {
            return false;
        }
        DescribeRulesResponse other = (DescribeRulesResponse)((Object)obj);
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Rule> rules;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRulesResponse model) {
            this.setRules(model.rules);
            this.setNextMarker(model.nextMarker);
        }

        public final Collection<Rule> getRules() {
            return this.rules;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>(rules.length);
            }
            for (Rule e : rules) {
                this.rules.add(e);
            }
            return this;
        }

        public final void setRules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(Rule ... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>(rules.length);
            }
            for (Rule e : rules) {
                this.rules.add(e);
            }
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeRulesResponse build() {
            return new DescribeRulesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRulesResponse> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder nextMarker(String var1);
    }
}

