/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.Listener;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListenerDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListenerDescription> {
    private static final SdkField<Listener> LISTENER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListenerDescription.getter(ListenerDescription::listener)).setter(ListenerDescription.setter(Builder::listener)).constructor(Listener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listener").build()}).build();
    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListenerDescription.getter(ListenerDescription::policyNames)).setter(ListenerDescription.setter(Builder::policyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_FIELD, POLICY_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Listener listener;
    private final List<String> policyNames;

    private ListenerDescription(BuilderImpl builder) {
        this.listener = builder.listener;
        this.policyNames = builder.policyNames;
    }

    public Listener listener() {
        return this.listener;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listener());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListenerDescription)) {
            return false;
        }
        ListenerDescription other = (ListenerDescription)obj;
        return Objects.equals(this.listener(), other.listener()) && Objects.equals(this.policyNames(), other.policyNames());
    }

    public String toString() {
        return ToString.builder((String)"ListenerDescription").add("Listener", (Object)this.listener()).add("PolicyNames", this.policyNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Listener": {
                return Optional.ofNullable(clazz.cast(this.listener()));
            }
            case "PolicyNames": {
                return Optional.ofNullable(clazz.cast(this.policyNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListenerDescription, T> g) {
        return obj -> g.apply((ListenerDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Listener listener;
        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListenerDescription model) {
            this.listener(model.listener);
            this.policyNames(model.policyNames);
        }

        public final Listener.Builder getListener() {
            return this.listener != null ? this.listener.toBuilder() : null;
        }

        @Override
        public final Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public final void setListener(Listener.BuilderImpl listener) {
            this.listener = listener != null ? listener.build() : null;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        public ListenerDescription build() {
            return new ListenerDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListenerDescription> {
        public Builder listener(Listener var1);

        default public Builder listener(Consumer<Listener.Builder> listener) {
            return this.listener((Listener)((Listener.Builder)Listener.builder().applyMutation(listener)).build());
        }

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);
    }
}

