/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetLoadBalancerPoliciesOfListenerRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, SetLoadBalancerPoliciesOfListenerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetLoadBalancerPoliciesOfListenerRequest.getter(SetLoadBalancerPoliciesOfListenerRequest::loadBalancerName)).setter(SetLoadBalancerPoliciesOfListenerRequest.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SetLoadBalancerPoliciesOfListenerRequest.getter(SetLoadBalancerPoliciesOfListenerRequest::loadBalancerPort)).setter(SetLoadBalancerPoliciesOfListenerRequest.setter(Builder::loadBalancerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()}).build();
    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SetLoadBalancerPoliciesOfListenerRequest.getter(SetLoadBalancerPoliciesOfListenerRequest::policyNames)).setter(SetLoadBalancerPoliciesOfListenerRequest.setter(Builder::policyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD, LOAD_BALANCER_PORT_FIELD, POLICY_NAMES_FIELD));
    private final String loadBalancerName;
    private final Integer loadBalancerPort;
    private final List<String> policyNames;

    private SetLoadBalancerPoliciesOfListenerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.policyNames = builder.policyNames;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public Integer loadBalancerPort() {
        return this.loadBalancerPort;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBalancerPoliciesOfListenerRequest)) {
            return false;
        }
        SetLoadBalancerPoliciesOfListenerRequest other = (SetLoadBalancerPoliciesOfListenerRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.loadBalancerPort(), other.loadBalancerPort()) && Objects.equals(this.policyNames(), other.policyNames());
    }

    public String toString() {
        return ToString.builder((String)"SetLoadBalancerPoliciesOfListenerRequest").add("LoadBalancerName", (Object)this.loadBalancerName()).add("LoadBalancerPort", (Object)this.loadBalancerPort()).add("PolicyNames", this.policyNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "LoadBalancerPort": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerPort()));
            }
            case "PolicyNames": {
                return Optional.ofNullable(clazz.cast(this.policyNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetLoadBalancerPoliciesOfListenerRequest, T> g) {
        return obj -> g.apply((SetLoadBalancerPoliciesOfListenerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private Integer loadBalancerPort;
        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBalancerPoliciesOfListenerRequest model) {
            super(model);
            this.loadBalancerName(model.loadBalancerName);
            this.loadBalancerPort(model.loadBalancerPort);
            this.policyNames(model.policyNames);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLoadBalancerPoliciesOfListenerRequest build() {
            return new SetLoadBalancerPoliciesOfListenerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetLoadBalancerPoliciesOfListenerRequest> {
        public Builder loadBalancerName(String var1);

        public Builder loadBalancerPort(Integer var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

