/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the state of an EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceState implements SdkPojo, Serializable, ToCopyableBuilder<InstanceState.Builder, InstanceState> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(InstanceState::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(InstanceState::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReasonCode").getter(getter(InstanceState::reasonCode)).setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(InstanceState::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            STATE_FIELD, REASON_CODE_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String state;

    private final String reasonCode;

    private final String description;

    private InstanceState(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.state = builder.state;
        this.reasonCode = builder.reasonCode;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * <p>
     * Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
     * </p>
     * 
     * @return The current state of the instance.</p>
     *         <p>
     *         Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * Information about the cause of <code>OutOfService</code> instances. Specifically, whether the cause is Elastic
     * Load Balancing or the instance.
     * </p>
     * <p>
     * Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
     * </p>
     * 
     * @return Information about the cause of <code>OutOfService</code> instances. Specifically, whether the cause is
     *         Elastic Load Balancing or the instance.</p>
     *         <p>
     *         Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
     */
    public final String reasonCode() {
        return reasonCode;
    }

    /**
     * <p>
     * A description of the instance state. This string can contain one or more of the following messages.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>N/A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>A transient error occurred. Please try again later.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance registration is still in progress.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance is not currently registered with the LoadBalancer.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance deregistration currently in progress.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Disable Availability Zone is currently in progress.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance is in pending state.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance is in stopped state.</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Instance is in terminated state.</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return A description of the instance state. This string can contain one or more of the following messages.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>N/A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>A transient error occurred. Please try again later.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance registration is still in progress.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance is not currently registered with the LoadBalancer.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance deregistration currently in progress.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Disable Availability Zone is currently in progress.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance is in pending state.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance is in stopped state.</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Instance is in terminated state.</code>
     *         </p>
     *         </li>
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceState)) {
            return false;
        }
        InstanceState other = (InstanceState) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(state(), other.state())
                && Objects.equals(reasonCode(), other.reasonCode()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceState").add("InstanceId", instanceId()).add("State", state())
                .add("ReasonCode", reasonCode()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "ReasonCode":
            return Optional.ofNullable(clazz.cast(reasonCode()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceState, T> g) {
        return obj -> g.apply((InstanceState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceState> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * <p>
         * Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
         * </p>
         * 
         * @param state
         *        The current state of the instance.</p>
         *        <p>
         *        Valid values: <code>InService</code> | <code>OutOfService</code> | <code>Unknown</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Information about the cause of <code>OutOfService</code> instances. Specifically, whether the cause is
         * Elastic Load Balancing or the instance.
         * </p>
         * <p>
         * Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
         * </p>
         * 
         * @param reasonCode
         *        Information about the cause of <code>OutOfService</code> instances. Specifically, whether the cause is
         *        Elastic Load Balancing or the instance.</p>
         *        <p>
         *        Valid values: <code>ELB</code> | <code>Instance</code> | <code>N/A</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCode(String reasonCode);

        /**
         * <p>
         * A description of the instance state. This string can contain one or more of the following messages.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>N/A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>A transient error occurred. Please try again later.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance registration is still in progress.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance is not currently registered with the LoadBalancer.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance deregistration currently in progress.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Disable Availability Zone is currently in progress.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance is in pending state.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance is in stopped state.</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Instance is in terminated state.</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param description
         *        A description of the instance state. This string can contain one or more of the following
         *        messages.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>N/A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>A transient error occurred. Please try again later.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance has failed at least the UnhealthyThreshold number of health checks consecutively.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance has not passed the configured HealthyThreshold number of health checks consecutively.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance registration is still in progress.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance is in the EC2 Availability Zone for which LoadBalancer is not configured to route traffic to.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance is not currently registered with the LoadBalancer.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance deregistration currently in progress.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Disable Availability Zone is currently in progress.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance is in pending state.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance is in stopped state.</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Instance is in terminated state.</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String state;

        private String reasonCode;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceState model) {
            instanceId(model.instanceId);
            state(model.state);
            reasonCode(model.reasonCode);
            description(model.description);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public InstanceState build() {
            return new InstanceState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
