/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateLoadBalancerListeners.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerListenersRequest extends ElasticLoadBalancingRequest implements
        ToCopyableBuilder<CreateLoadBalancerListenersRequest.Builder, CreateLoadBalancerListenersRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerName").getter(getter(CreateLoadBalancerListenersRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()).build();

    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField
            .<List<Listener>> builder(MarshallingType.LIST)
            .memberName("Listeners")
            .getter(getter(CreateLoadBalancerListenersRequest::listeners))
            .setter(setter(Builder::listeners))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Listeners").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Listener> builder(MarshallingType.SDK_POJO)
                                            .constructor(Listener::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            LISTENERS_FIELD));

    private final String loadBalancerName;

    private final List<Listener> listeners;

    private CreateLoadBalancerListenersRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.listeners = builder.listeners;
    }

    /**
     * <p>
     * The name of the load balancer.
     * </p>
     * 
     * @return The name of the load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Listeners property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasListeners() {
        return listeners != null && !(listeners instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The listeners.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListeners} method.
     * </p>
     * 
     * @return The listeners.
     */
    public final List<Listener> listeners() {
        return listeners;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(hasListeners() ? listeners() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerListenersRequest)) {
            return false;
        }
        CreateLoadBalancerListenersRequest other = (CreateLoadBalancerListenersRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName()) && hasListeners() == other.hasListeners()
                && Objects.equals(listeners(), other.listeners());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLoadBalancerListenersRequest").add("LoadBalancerName", loadBalancerName())
                .add("Listeners", hasListeners() ? listeners() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "Listeners":
            return Optional.ofNullable(clazz.cast(listeners()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerListenersRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerListenersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLoadBalancerListenersRequest> {
        /**
         * <p>
         * The name of the load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The listeners.
         * </p>
         * 
         * @param listeners
         *        The listeners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Collection<Listener> listeners);

        /**
         * <p>
         * The listeners.
         * </p>
         * 
         * @param listeners
         *        The listeners.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listeners(Listener... listeners);

        /**
         * <p>
         * The listeners.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.Listener.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.elasticloadbalancing.model.Listener#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.Listener.Builder#build()} is called
         * immediately and its result is passed to {@link #listeners(List<Listener>)}.
         * 
         * @param listeners
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancing.model.Listener.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listeners(java.util.Collection<Listener>)
         */
        Builder listeners(Consumer<Listener.Builder>... listeners);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerListenersRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            listeners(model.listeners);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final List<Listener.Builder> getListeners() {
            List<Listener.Builder> result = ListenersCopier.copyToBuilder(this.listeners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener... listeners) {
            listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder>... listeners) {
            listeners(Stream.of(listeners).map(c -> Listener.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerListenersRequest build() {
            return new CreateLoadBalancerListenersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
