/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticloadbalancing.DefaultElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.DefaultElasticLoadBalancingBaseClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClientBuilder;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingServiceClientConfiguration;
import software.amazon.awssdk.services.elasticloadbalancing.endpoints.ElasticLoadBalancingEndpointProvider;

@SdkInternalApi
final class DefaultElasticLoadBalancingAsyncClientBuilder
extends DefaultElasticLoadBalancingBaseClientBuilder<ElasticLoadBalancingAsyncClientBuilder, ElasticLoadBalancingAsyncClient>
implements ElasticLoadBalancingAsyncClientBuilder {
    DefaultElasticLoadBalancingAsyncClientBuilder() {
    }

    @Override
    public DefaultElasticLoadBalancingAsyncClientBuilder endpointProvider(ElasticLoadBalancingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticLoadBalancingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElasticLoadBalancingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ElasticLoadBalancingServiceClientConfiguration serviceClientConfiguration = ElasticLoadBalancingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultElasticLoadBalancingAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

