/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.endpoints.internal;

import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.elasticloadbalancing.endpoints.ElasticLoadBalancingEndpointParams;
import software.amazon.awssdk.services.elasticloadbalancing.endpoints.ElasticLoadBalancingEndpointProvider;
import software.amazon.awssdk.services.elasticloadbalancing.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class ElasticLoadBalancingResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        ElasticLoadBalancingEndpointProvider provider = (ElasticLoadBalancingEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Endpoint result = provider.resolveEndpoint(ElasticLoadBalancingResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static ElasticLoadBalancingEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        ElasticLoadBalancingEndpointParams.Builder builder = ElasticLoadBalancingEndpointParams.builder();
        ElasticLoadBalancingResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        ElasticLoadBalancingResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        return builder.build();
    }

    private static void setContextParams(ElasticLoadBalancingEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            default: 
        }
    }

    private static void setStaticContextParams(ElasticLoadBalancingEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            default: 
        }
    }
}

