/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheck> {
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(HealthCheck.getter(HealthCheck::target)).setter(HealthCheck.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Interval").getter(HealthCheck.getter(HealthCheck::interval)).setter(HealthCheck.setter(Builder::interval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(HealthCheck.getter(HealthCheck::timeout)).setter(HealthCheck.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UnhealthyThreshold").getter(HealthCheck.getter(HealthCheck::unhealthyThreshold)).setter(HealthCheck.setter(Builder::unhealthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThreshold").build()}).build();
    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HealthyThreshold").getter(HealthCheck.getter(HealthCheck::healthyThreshold)).setter(HealthCheck.setter(Builder::healthyThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, INTERVAL_FIELD, TIMEOUT_FIELD, UNHEALTHY_THRESHOLD_FIELD, HEALTHY_THRESHOLD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String target;
    private final Integer interval;
    private final Integer timeout;
    private final Integer unhealthyThreshold;
    private final Integer healthyThreshold;

    private HealthCheck(BuilderImpl builder) {
        this.target = builder.target;
        this.interval = builder.interval;
        this.timeout = builder.timeout;
        this.unhealthyThreshold = builder.unhealthyThreshold;
        this.healthyThreshold = builder.healthyThreshold;
    }

    public final String target() {
        return this.target;
    }

    public final Integer interval() {
        return this.interval;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final Integer unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public final Integer healthyThreshold() {
        return this.healthyThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthyThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)obj;
        return Objects.equals(this.target(), other.target()) && Objects.equals(this.interval(), other.interval()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.unhealthyThreshold(), other.unhealthyThreshold()) && Objects.equals(this.healthyThreshold(), other.healthyThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheck").add("Target", (Object)this.target()).add("Interval", (Object)this.interval()).add("Timeout", (Object)this.timeout()).add("UnhealthyThreshold", (Object)this.unhealthyThreshold()).add("HealthyThreshold", (Object)this.healthyThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "UnhealthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.unhealthyThreshold()));
            }
            case "HealthyThreshold": {
                return Optional.ofNullable(clazz.cast(this.healthyThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheck, T> g) {
        return obj -> g.apply((HealthCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String target;
        private Integer interval;
        private Integer timeout;
        private Integer unhealthyThreshold;
        private Integer healthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            this.target(model.target);
            this.interval(model.interval);
            this.timeout(model.timeout);
            this.unhealthyThreshold(model.unhealthyThreshold);
            this.healthyThreshold(model.healthyThreshold);
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        @Transient
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Integer getInterval() {
            return this.interval;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        @Override
        @Transient
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        @Transient
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        @Override
        @Transient
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public final Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        @Override
        @Transient
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheck> {
        public Builder target(String var1);

        public Builder interval(Integer var1);

        public Builder timeout(Integer var1);

        public Builder unhealthyThreshold(Integer var1);

        public Builder healthyThreshold(Integer var1);
    }
}

