/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Listener
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Listener> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(Listener.getter(Listener::protocol)).setter(Listener.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LoadBalancerPort").getter(Listener.getter(Listener::loadBalancerPort)).setter(Listener.setter(Builder::loadBalancerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()}).build();
    private static final SdkField<String> INSTANCE_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProtocol").getter(Listener.getter(Listener::instanceProtocol)).setter(Listener.setter(Builder::instanceProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProtocol").build()}).build();
    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancePort").getter(Listener.getter(Listener::instancePort)).setter(Listener.setter(Builder::instancePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePort").build()}).build();
    private static final SdkField<String> SSL_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSLCertificateId").getter(Listener.getter(Listener::sslCertificateId)).setter(Listener.setter(Builder::sslCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSLCertificateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, LOAD_BALANCER_PORT_FIELD, INSTANCE_PROTOCOL_FIELD, INSTANCE_PORT_FIELD, SSL_CERTIFICATE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final Integer loadBalancerPort;
    private final String instanceProtocol;
    private final Integer instancePort;
    private final String sslCertificateId;

    private Listener(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.instanceProtocol = builder.instanceProtocol;
        this.instancePort = builder.instancePort;
        this.sslCertificateId = builder.sslCertificateId;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final Integer loadBalancerPort() {
        return this.loadBalancerPort;
    }

    public final String instanceProtocol() {
        return this.instanceProtocol;
    }

    public final Integer instancePort() {
        return this.instancePort;
    }

    public final String sslCertificateId() {
        return this.sslCertificateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCertificateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.loadBalancerPort(), other.loadBalancerPort()) && Objects.equals(this.instanceProtocol(), other.instanceProtocol()) && Objects.equals(this.instancePort(), other.instancePort()) && Objects.equals(this.sslCertificateId(), other.sslCertificateId());
    }

    public final String toString() {
        return ToString.builder((String)"Listener").add("Protocol", (Object)this.protocol()).add("LoadBalancerPort", (Object)this.loadBalancerPort()).add("InstanceProtocol", (Object)this.instanceProtocol()).add("InstancePort", (Object)this.instancePort()).add("SSLCertificateId", (Object)this.sslCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "LoadBalancerPort": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerPort()));
            }
            case "InstanceProtocol": {
                return Optional.ofNullable(clazz.cast(this.instanceProtocol()));
            }
            case "InstancePort": {
                return Optional.ofNullable(clazz.cast(this.instancePort()));
            }
            case "SSLCertificateId": {
                return Optional.ofNullable(clazz.cast(this.sslCertificateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private Integer loadBalancerPort;
        private String instanceProtocol;
        private Integer instancePort;
        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            this.protocol(model.protocol);
            this.loadBalancerPort(model.loadBalancerPort);
            this.instanceProtocol(model.instanceProtocol);
            this.instancePort(model.instancePort);
            this.sslCertificateId(model.sslCertificateId);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        @Override
        @Transient
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final String getInstanceProtocol() {
            return this.instanceProtocol;
        }

        public final void setInstanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
        }

        @Override
        @Transient
        public final Builder instanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
            return this;
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        @Override
        @Transient
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final String getSslCertificateId() {
            return this.sslCertificateId;
        }

        public final void setSslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        @Transient
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public Listener build() {
            return new Listener(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Listener> {
        public Builder protocol(String var1);

        public Builder loadBalancerPort(Integer var1);

        public Builder instanceProtocol(String var1);

        public Builder instancePort(Integer var1);

        public Builder sslCertificateId(String var1);
    }
}

