/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingResponse;
import software.amazon.awssdk.services.elasticloadbalancing.model.HealthCheck;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureHealthCheckResponse
extends ElasticLoadBalancingResponse
implements ToCopyableBuilder<Builder, ConfigureHealthCheckResponse> {
    private static final SdkField<HealthCheck> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConfigureHealthCheckResponse.getter(ConfigureHealthCheckResponse::healthCheck)).setter(ConfigureHealthCheckResponse.setter(Builder::healthCheck)).constructor(HealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD));
    private final HealthCheck healthCheck;

    private ConfigureHealthCheckResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheck = builder.healthCheck;
    }

    public HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureHealthCheckResponse)) {
            return false;
        }
        ConfigureHealthCheckResponse other = (ConfigureHealthCheckResponse)((Object)obj);
        return Objects.equals(this.healthCheck(), other.healthCheck());
    }

    public String toString() {
        return ToString.builder((String)"ConfigureHealthCheckResponse").add("HealthCheck", (Object)this.healthCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureHealthCheckResponse, T> g) {
        return obj -> g.apply((ConfigureHealthCheckResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingResponse.BuilderImpl
    implements Builder {
        private HealthCheck healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureHealthCheckResponse model) {
            super(model);
            this.healthCheck(model.healthCheck);
        }

        public final HealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public ConfigureHealthCheckResponse build() {
            return new ConfigureHealthCheckResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureHealthCheckResponse> {
        public Builder healthCheck(HealthCheck var1);

        default public Builder healthCheck(Consumer<HealthCheck.Builder> healthCheck) {
            return this.healthCheck((HealthCheck)((HealthCheck.Builder)HealthCheck.builder().applyMutation(healthCheck)).build());
        }
    }
}

