/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPoliciesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPoliciesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.LBCookieStickinessPolicy;
import software.amazon.awssdk.services.elasticloadbalancing.model.PolicyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Policies
implements ToCopyableBuilder<Builder, Policies> {
    private final List<AppCookieStickinessPolicy> appCookieStickinessPolicies;
    private final List<LBCookieStickinessPolicy> lbCookieStickinessPolicies;
    private final List<String> otherPolicies;

    private Policies(BuilderImpl builder) {
        this.appCookieStickinessPolicies = builder.appCookieStickinessPolicies;
        this.lbCookieStickinessPolicies = builder.lbCookieStickinessPolicies;
        this.otherPolicies = builder.otherPolicies;
    }

    public List<AppCookieStickinessPolicy> appCookieStickinessPolicies() {
        return this.appCookieStickinessPolicies;
    }

    public List<LBCookieStickinessPolicy> lbCookieStickinessPolicies() {
        return this.lbCookieStickinessPolicies;
    }

    public List<String> otherPolicies() {
        return this.otherPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appCookieStickinessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.lbCookieStickinessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherPolicies());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policies)) {
            return false;
        }
        Policies other = (Policies)obj;
        return Objects.equals(this.appCookieStickinessPolicies(), other.appCookieStickinessPolicies()) && Objects.equals(this.lbCookieStickinessPolicies(), other.lbCookieStickinessPolicies()) && Objects.equals(this.otherPolicies(), other.otherPolicies());
    }

    public String toString() {
        return ToString.builder((String)"Policies").add("AppCookieStickinessPolicies", this.appCookieStickinessPolicies()).add("LBCookieStickinessPolicies", this.lbCookieStickinessPolicies()).add("OtherPolicies", this.otherPolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppCookieStickinessPolicies": {
                return Optional.of(clazz.cast(this.appCookieStickinessPolicies()));
            }
            case "LBCookieStickinessPolicies": {
                return Optional.of(clazz.cast(this.lbCookieStickinessPolicies()));
            }
            case "OtherPolicies": {
                return Optional.of(clazz.cast(this.otherPolicies()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AppCookieStickinessPolicy> appCookieStickinessPolicies;
        private List<LBCookieStickinessPolicy> lbCookieStickinessPolicies;
        private List<String> otherPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(Policies model) {
            this.appCookieStickinessPolicies(model.appCookieStickinessPolicies);
            this.lbCookieStickinessPolicies(model.lbCookieStickinessPolicies);
            this.otherPolicies(model.otherPolicies);
        }

        public final Collection<AppCookieStickinessPolicy.Builder> getAppCookieStickinessPolicies() {
            return this.appCookieStickinessPolicies != null ? (Collection)this.appCookieStickinessPolicies.stream().map(AppCookieStickinessPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copy(appCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(AppCookieStickinessPolicy ... appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies(Arrays.asList(appCookieStickinessPolicies));
            return this;
        }

        public final void setAppCookieStickinessPolicies(Collection<AppCookieStickinessPolicy.BuilderImpl> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AppCookieStickinessPoliciesCopier.copyFromBuilder(appCookieStickinessPolicies);
        }

        public final Collection<LBCookieStickinessPolicy.Builder> getLBCookieStickinessPolicies() {
            return this.lbCookieStickinessPolicies != null ? (Collection)this.lbCookieStickinessPolicies.stream().map(LBCookieStickinessPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copy(lbCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy ... lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies(Arrays.asList(lbCookieStickinessPolicies));
            return this;
        }

        public final void setLBCookieStickinessPolicies(Collection<LBCookieStickinessPolicy.BuilderImpl> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = LBCookieStickinessPoliciesCopier.copyFromBuilder(lbCookieStickinessPolicies);
        }

        public final Collection<String> getOtherPolicies() {
            return this.otherPolicies;
        }

        @Override
        public final Builder otherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherPolicies(String ... otherPolicies) {
            this.otherPolicies(Arrays.asList(otherPolicies));
            return this;
        }

        public final void setOtherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = PolicyNamesCopier.copy(otherPolicies);
        }

        public Policies build() {
            return new Policies(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Policies> {
        public Builder appCookieStickinessPolicies(Collection<AppCookieStickinessPolicy> var1);

        public Builder appCookieStickinessPolicies(AppCookieStickinessPolicy ... var1);

        public Builder lbCookieStickinessPolicies(Collection<LBCookieStickinessPolicy> var1);

        public Builder lbCookieStickinessPolicies(LBCookieStickinessPolicy ... var1);

        public Builder otherPolicies(Collection<String> var1);

        public Builder otherPolicies(String ... var1);
    }
}

