/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNamesMax20Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, DescribeTagsRequest> {
    private final List<String> loadBalancerNames;

    private DescribeTagsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerNames = builder.loadBalancerNames;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsRequest)) {
            return false;
        }
        DescribeTagsRequest other = (DescribeTagsRequest)((Object)obj);
        return Objects.equals(this.loadBalancerNames(), other.loadBalancerNames());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTagsRequest").add("LoadBalancerNames", this.loadBalancerNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerNames": {
                return Optional.of(clazz.cast(this.loadBalancerNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private List<String> loadBalancerNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsRequest model) {
            this.loadBalancerNames(model.loadBalancerNames);
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesMax20Copier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesMax20Copier.copy(loadBalancerNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, DescribeTagsRequest> {
        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

