/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;

public class DescribeLoadBalancersRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancersRequest>, DescribeLoadBalancersRequest> {
    public Request<DescribeLoadBalancersRequest> marshall(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        if (describeLoadBalancersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeLoadBalancersRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeLoadBalancers");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> loadBalancerNamesList = describeLoadBalancersRequest.loadBalancerNames();
        if (loadBalancerNamesList != null) {
            if (!loadBalancerNamesList.isEmpty()) {
                int loadBalancerNamesListIndex = 1;
                for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                    if (loadBalancerNamesListValue != null) {
                        request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
                    }
                    ++loadBalancerNamesListIndex;
                }
            } else {
                request.addParameter("LoadBalancerNames", "");
            }
        }
        if (describeLoadBalancersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeLoadBalancersRequest.marker()));
        }
        if (describeLoadBalancersRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeLoadBalancersRequest.pageSize()));
        }
        return request;
    }
}

