/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccessLog
implements ToCopyableBuilder<Builder, AccessLog> {
    private final Boolean enabled;
    private final String s3BucketName;
    private final Integer emitInterval;
    private final String s3BucketPrefix;

    private AccessLog(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.s3BucketName = builder.s3BucketName;
        this.emitInterval = builder.emitInterval;
        this.s3BucketPrefix = builder.s3BucketPrefix;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public Integer emitInterval() {
        return this.emitInterval;
    }

    public String s3BucketPrefix() {
        return this.s3BucketPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emitInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketPrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLog)) {
            return false;
        }
        AccessLog other = (AccessLog)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.emitInterval(), other.emitInterval()) && Objects.equals(this.s3BucketPrefix(), other.s3BucketPrefix());
    }

    public String toString() {
        return ToString.builder((String)"AccessLog").add("Enabled", (Object)this.enabled()).add("S3BucketName", (Object)this.s3BucketName()).add("EmitInterval", (Object)this.emitInterval()).add("S3BucketPrefix", (Object)this.s3BucketPrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "S3BucketName": {
                return Optional.of(clazz.cast(this.s3BucketName()));
            }
            case "EmitInterval": {
                return Optional.of(clazz.cast(this.emitInterval()));
            }
            case "S3BucketPrefix": {
                return Optional.of(clazz.cast(this.s3BucketPrefix()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String s3BucketName;
        private Integer emitInterval;
        private String s3BucketPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLog model) {
            this.enabled(model.enabled);
            this.s3BucketName(model.s3BucketName);
            this.emitInterval(model.emitInterval);
            this.s3BucketPrefix(model.s3BucketPrefix);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final Integer getEmitInterval() {
            return this.emitInterval;
        }

        @Override
        public final Builder emitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
            return this;
        }

        public final void setEmitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
        }

        public final String getS3BucketPrefix() {
            return this.s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        public AccessLog build() {
            return new AccessLog(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccessLog> {
        public Builder enabled(Boolean var1);

        public Builder s3BucketName(String var1);

        public Builder emitInterval(Integer var1);

        public Builder s3BucketPrefix(String var1);
    }
}

