/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticloadbalancing.model.ElasticLoadBalancingRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLBCookieStickinessPolicyRequest
extends ElasticLoadBalancingRequest
implements ToCopyableBuilder<Builder, CreateLBCookieStickinessPolicyRequest> {
    private final String loadBalancerName;
    private final String policyName;
    private final Long cookieExpirationPeriod;

    private CreateLBCookieStickinessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
        this.cookieExpirationPeriod = builder.cookieExpirationPeriod;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String policyName() {
        return this.policyName;
    }

    public Long cookieExpirationPeriod() {
        return this.cookieExpirationPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookieExpirationPeriod());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLBCookieStickinessPolicyRequest)) {
            return false;
        }
        CreateLBCookieStickinessPolicyRequest other = (CreateLBCookieStickinessPolicyRequest)((Object)obj);
        return Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.cookieExpirationPeriod(), other.cookieExpirationPeriod());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (this.cookieExpirationPeriod() != null) {
            sb.append("CookieExpirationPeriod: ").append(this.cookieExpirationPeriod()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "CookieExpirationPeriod": {
                return Optional.of(clazz.cast(this.cookieExpirationPeriod()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingRequest.BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String policyName;
        private Long cookieExpirationPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLBCookieStickinessPolicyRequest model) {
            this.loadBalancerName(model.loadBalancerName);
            this.policyName(model.policyName);
            this.cookieExpirationPeriod(model.cookieExpirationPeriod);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Long getCookieExpirationPeriod() {
            return this.cookieExpirationPeriod;
        }

        @Override
        public final Builder cookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
            return this;
        }

        public final void setCookieExpirationPeriod(Long cookieExpirationPeriod) {
            this.cookieExpirationPeriod = cookieExpirationPeriod;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLBCookieStickinessPolicyRequest build() {
            return new CreateLBCookieStickinessPolicyRequest(this);
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingRequest.Builder,
    CopyableBuilder<Builder, CreateLBCookieStickinessPolicyRequest> {
        public Builder loadBalancerName(String var1);

        public Builder policyName(String var1);

        public Builder cookieExpirationPeriod(Long var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

