/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        if (describeTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTagsRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> loadBalancerNamesList = describeTagsRequest.loadBalancerNames();
        if (loadBalancerNamesList != null) {
            if (!loadBalancerNamesList.isEmpty()) {
                int loadBalancerNamesListIndex = 1;
                for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                    if (loadBalancerNamesListValue != null) {
                        request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
                    }
                    ++loadBalancerNamesListIndex;
                }
            } else {
                request.addParameter("LoadBalancerNames", "");
            }
        }
        return request;
    }
}

