/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.Instance;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstancesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterInstancesWithLoadBalancerResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, RegisterInstancesWithLoadBalancerResponse> {
    private final List<Instance> instances;

    private RegisterInstancesWithLoadBalancerResponse(BuilderImpl builder) {
        this.instances = builder.instances;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstancesWithLoadBalancerResponse)) {
            return false;
        }
        RegisterInstancesWithLoadBalancerResponse other = (RegisterInstancesWithLoadBalancerResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Instance> instances;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstancesWithLoadBalancerResponse model) {
            this.instances(model.instances);
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        public RegisterInstancesWithLoadBalancerResponse build() {
            return new RegisterInstancesWithLoadBalancerResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterInstancesWithLoadBalancerResponse> {
        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);
    }
}

