/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;

public class DescribeLoadBalancerPolicyTypesRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancerPolicyTypesRequest>, DescribeLoadBalancerPolicyTypesRequest> {
    public Request<DescribeLoadBalancerPolicyTypesRequest> marshall(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        if (describeLoadBalancerPolicyTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLoadBalancerPolicyTypesRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeLoadBalancerPolicyTypes");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> policyTypeNamesList = describeLoadBalancerPolicyTypesRequest.policyTypeNames();
        if (policyTypeNamesList != null) {
            if (!policyTypeNamesList.isEmpty()) {
                int policyTypeNamesListIndex = 1;
                for (String policyTypeNamesListValue : policyTypeNamesList) {
                    if (policyTypeNamesListValue != null) {
                        request.addParameter("PolicyTypeNames.member." + policyTypeNamesListIndex, StringUtils.fromString((String)policyTypeNamesListValue));
                    }
                    ++policyTypeNamesListIndex;
                }
            } else {
                request.addParameter("PolicyTypeNames", "");
            }
        }
        return request;
    }
}

