/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;

public class AttachLoadBalancerToSubnetsRequestMarshaller
implements Marshaller<Request<AttachLoadBalancerToSubnetsRequest>, AttachLoadBalancerToSubnetsRequest> {
    public Request<AttachLoadBalancerToSubnetsRequest> marshall(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) {
        List<String> subnetsList;
        if (attachLoadBalancerToSubnetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachLoadBalancerToSubnetsRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "AttachLoadBalancerToSubnets");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachLoadBalancerToSubnetsRequest.loadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString((String)attachLoadBalancerToSubnetsRequest.loadBalancerName()));
        }
        if ((subnetsList = attachLoadBalancerToSubnetsRequest.subnets()) != null) {
            if (!subnetsList.isEmpty()) {
                int subnetsListIndex = 1;
                for (String subnetsListValue : subnetsList) {
                    if (subnetsListValue != null) {
                        request.addParameter("Subnets.member." + subnetsListIndex, StringUtils.fromString((String)subnetsListValue));
                    }
                    ++subnetsListIndex;
                }
            } else {
                request.addParameter("Subnets", "");
            }
        }
        return request;
    }
}

