/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState;
import software.amazon.awssdk.services.elasticloadbalancing.model.InstanceStatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceHealthResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstanceHealthResponse> {
    private final List<InstanceState> instanceStates;

    private DescribeInstanceHealthResponse(BuilderImpl builder) {
        this.instanceStates = builder.instanceStates;
    }

    public List<InstanceState> instanceStates() {
        return this.instanceStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceStates() == null ? 0 : this.instanceStates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceHealthResponse)) {
            return false;
        }
        DescribeInstanceHealthResponse other = (DescribeInstanceHealthResponse)((Object)obj);
        if (other.instanceStates() == null ^ this.instanceStates() == null) {
            return false;
        }
        return other.instanceStates() == null || other.instanceStates().equals(this.instanceStates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceStates() != null) {
            sb.append("InstanceStates: ").append(this.instanceStates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceStates": {
                return Optional.of(clazz.cast(this.instanceStates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceState> instanceStates;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceHealthResponse model) {
            this.instanceStates(model.instanceStates);
        }

        public final Collection<InstanceState.Builder> getInstanceStates() {
            return this.instanceStates != null ? (Collection)this.instanceStates.stream().map(InstanceState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState ... instanceStates) {
            this.instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        public final void setInstanceStates(Collection<InstanceState.BuilderImpl> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copyFromBuilder(instanceStates);
        }

        public DescribeInstanceHealthResponse build() {
            return new DescribeInstanceHealthResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceHealthResponse> {
        public Builder instanceStates(Collection<InstanceState> var1);

        public Builder instanceStates(InstanceState ... var1);
    }
}

