/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteLoadBalancerPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteLoadBalancerPolicyRequest> {
    private final String loadBalancerName;
    private final String policyName;

    private DeleteLoadBalancerPolicyRequest(BuilderImpl builder) {
        this.loadBalancerName = builder.loadBalancerName;
        this.policyName = builder.policyName;
    }

    public String loadBalancerName() {
        return this.loadBalancerName;
    }

    public String policyName() {
        return this.policyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerName() == null ? 0 : this.loadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.policyName() == null ? 0 : this.policyName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLoadBalancerPolicyRequest)) {
            return false;
        }
        DeleteLoadBalancerPolicyRequest other = (DeleteLoadBalancerPolicyRequest)((Object)obj);
        if (other.loadBalancerName() == null ^ this.loadBalancerName() == null) {
            return false;
        }
        if (other.loadBalancerName() != null && !other.loadBalancerName().equals(this.loadBalancerName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        return other.policyName() == null || other.policyName().equals(this.policyName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerName() != null) {
            sb.append("LoadBalancerName: ").append(this.loadBalancerName()).append(",");
        }
        if (this.policyName() != null) {
            sb.append("PolicyName: ").append(this.policyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerName": {
                return Optional.of(clazz.cast(this.loadBalancerName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerName;
        private String policyName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLoadBalancerPolicyRequest model) {
            this.loadBalancerName(model.loadBalancerName);
            this.policyName(model.policyName);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public DeleteLoadBalancerPolicyRequest build() {
            return new DeleteLoadBalancerPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteLoadBalancerPolicyRequest> {
        public Builder loadBalancerName(String var1);

        public Builder policyName(String var1);
    }
}

