/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerNamesCopier;
import software.amazon.awssdk.services.elasticloadbalancing.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancing.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddTagsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddTagsRequest> {
    private final List<String> loadBalancerNames;
    private final List<Tag> tags;

    private AddTagsRequest(BuilderImpl builder) {
        this.loadBalancerNames = builder.loadBalancerNames;
        this.tags = builder.tags;
    }

    public List<String> loadBalancerNames() {
        return this.loadBalancerNames;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancerNames() == null ? 0 : this.loadBalancerNames().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest)((Object)obj);
        if (other.loadBalancerNames() == null ^ this.loadBalancerNames() == null) {
            return false;
        }
        if (other.loadBalancerNames() != null && !other.loadBalancerNames().equals(this.loadBalancerNames())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.loadBalancerNames() != null) {
            sb.append("LoadBalancerNames: ").append(this.loadBalancerNames()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerNames": {
                return Optional.of(clazz.cast(this.loadBalancerNames()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> loadBalancerNames;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsRequest model) {
            this.loadBalancerNames(model.loadBalancerNames);
            this.tags(model.tags);
        }

        public final Collection<String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String ... loadBalancerNames) {
            this.loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = LoadBalancerNamesCopier.copy(loadBalancerNames);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public AddTagsRequest build() {
            return new AddTagsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddTagsRequest> {
        public Builder loadBalancerNames(Collection<String> var1);

        public Builder loadBalancerNames(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

