/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAccountLimitsRequestMarshaller
implements Marshaller<Request<DescribeAccountLimitsRequest>, DescribeAccountLimitsRequest> {
    public Request<DescribeAccountLimitsRequest> marshall(DescribeAccountLimitsRequest describeAccountLimitsRequest) {
        if (describeAccountLimitsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAccountLimitsRequest, "ElasticLoadBalancingClient");
        request.addParameter("Action", "DescribeAccountLimits");
        request.addParameter("Version", "2012-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAccountLimitsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeAccountLimitsRequest.marker()));
        }
        if (describeAccountLimitsRequest.pageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeAccountLimitsRequest.pageSize()));
        }
        return request;
    }
}

