/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticloadbalancing.model.AccessLog;

public class AccessLogUnmarshaller
implements Unmarshaller<AccessLog, StaxUnmarshallerContext> {
    private static final AccessLogUnmarshaller INSTANCE = new AccessLogUnmarshaller();

    public AccessLog unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AccessLog.Builder accessLog = AccessLog.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    accessLog.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3BucketName", targetDepth)) {
                    accessLog.s3BucketName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EmitInterval", targetDepth)) {
                    accessLog.emitInterval(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("S3BucketPrefix", targetDepth)) continue;
                accessLog.s3BucketPrefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AccessLog)accessLog.build();
    }

    public static AccessLogUnmarshaller getInstance() {
        return INSTANCE;
    }
}

