/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.jmespath.JmesPathEvaluationVisitor;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.jmespath.JmesPathField;
import software.amazon.awssdk.jmespath.JmesPathFlatten;
import software.amazon.awssdk.jmespath.JmesPathProjection;
import software.amazon.awssdk.jmespath.JmesPathVisitor;
import software.amazon.awssdk.jmespath.ObjectMapperSingleton;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class InstanceDeregistered {
    InstanceDeregistered() {
    }

    static class IsInvalidInstanceMatcher
    extends WaiterAcceptor<DescribeInstanceHealthResponse> {
        IsInvalidInstanceMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "InvalidInstance".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }

    static class IsOutOfServiceMatcher
    extends WaiterAcceptor<DescribeInstanceHealthResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsOutOfServiceMatcher() {
        }

        public boolean matches(DescribeInstanceHealthResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAll((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"OutOfService\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("InstanceStates")), (JmesPathExpression)new JmesPathField("State"));
        }
    }
}

